<?php
global $wpdb;

// текущая версия ядря
$current_wpg_core_version = get_option('wpg_core_version');
// текущая версия плагина
$current_wpg_version = get_option('wpg_version');

if (!$current_wpg_version) { // версия не определена, ставим 1.1.7
    update_option('wpg_core_version', '1.1.7', 'no');
    update_option('wpg_version', '1.1.7', 'no');
    $current_wpg_version = '1.1.7';
} elseif ($current_wpg_core_version === false and $current_wpg_version !== false) {
    $current_wpg_core_version = $current_wpg_version;
    update_option('wpg_core_version', $current_wpg_core_version, 'no');
}


$sql = file_get_contents(WPGRABBER_PLUGIN_INSTALL_DIR . 'install.sql');
if (empty($sql)) {
    die('Сбой при установке плагина. Не найден файл SQL.');
}
$sql = str_replace('{wp_table_prefix}', $wpdb->prefix, $sql);
$sql = explode(';', trim($sql, ';'));
if (count($sql)) {
    foreach ($sql as $_sql) {
        if (!$wpdb->query($_sql)) {
            die('Сбой при установке плагина. Ошибка SQL: ' . $wpdb->last_error);
        }
    }
}

if ($current_wpg_core_version === false) {

    // Новая установка
    $sql = file_get_contents(WPGRABBER_PLUGIN_INSTALL_DIR . 'test-feeds.sql');
    if (empty($sql)) {
        die('Сбой при установке плагина. Не найден файл SQL тестовых лент.');
    }
    $sql = str_replace('wp_', $wpdb->prefix, $sql);
    $sql = explode(';', trim($sql, ';'));
    if (count($sql)) {
        foreach ($sql as $_sql) {
            if (!$wpdb->query($_sql)) {
                die('Сбой при установке плагина. Ошибка SQL тестовых лент: ' . $wpdb->last_error);
            }
        }
    }
    update_option('wpg_version', WPGRABBER_VERSION, 'no');
    update_option('wpg_core_version', WPGRABBER_CORE_VERSION, 'no');

    update_option('wpg_testPath', '/wp-content/wpgrabber_tmp/', 'no');
    update_option('wpg_imgPath', '/wp-content/uploads/', 'no');
    update_option('wpg_phpTimeLimit', '', 'no');

    update_option('wpg_useTransactionModel', 1, 'no');
    update_option('wpg_logErrors', 1, 'no');
    update_option('wpg_sendErrors', 0, 'no');
    update_option('wpg_curlRedirectOn', 1, 'no');
    update_option('wpg_curlCookiesOn', 1, 'no');
    update_option('wpg_curlGzipOn', 1, 'no');
    update_option('wpg_saveFileUrlMethod', 1, 'no');
    update_option('wpg_postFulltextSymbolEnd', '.', 'no');
    update_option('wpg_post_full_size', '370', 'no');
    update_option('wpg_curlProxyHostPort', '127.0.0.1:8080', 'no');
    update_option('wpg_curlProxyType', 0, 'no');
} else {
    // Плагин был ранее установлен, обновляем
    if (version_compare($current_wpg_core_version, '1.1.8', '<')) {
        // в версиях ниже 1.1.8 нет таблицы wpgrabber_errors
        $sql = file_get_contents(WPGRABBER_PLUGIN_INSTALL_DIR . 'install.sql');
        if (empty($sql)) {
            die('Сбой при установке плагина. Не найден файл SQL.');
        }
        preg_match('|CREATE TABLE IF NOT EXISTS `{wp_table_prefix}wpgrabber_errors` .*?;|is', $sql, $buff);
        $sql = $buff[0];
        $sql = str_replace('{wp_table_prefix}', $wpdb->prefix, $sql);
        if (!$wpdb->query($sql)) {
            die('Сбой при установке плагина. Ошибка SQL: ' . $wpdb->last_error);
        }

        // обновляем поле params для всех лент, кодируя значение этого поля в base64_encode()
        /*      $rows = $wpdb->get_results("SELECT `id`, `params` FROM `{$wpdb->prefix}wpgrabber`");
              if (count($rows)) {
                foreach ($rows as $row) {
                  $params = '';
                  $params = base64_encode($row->params);
                  $result = $wpdb->update($wpdb->prefix.'wpgrabber',
                    array(
                      'params' => $params,
                    ),
                    array('id' => $row->id)
                  );
                  if ($result === false) {
                    die('Сбой при установке плагина. Ошибка обновления параметров версий ниже 1.1.8.');
                  }
                }
              }
       */
    }
    if (version_compare($current_wpg_core_version, '2.0.0', '<')) {
        update_option('wpg_useTransactionModel', 1);
        update_option('wpg_logErrors', 1, ' ', 'no');
        update_option('wpg_sendErrors', 0, ' ', 'no');
    }
    if (version_compare($current_wpg_core_version, '3.0.2', '<')) {
        if (WPGWordPressDB::isField($wpdb->prefix . 'wpgrabber', 'catid')) {
            $rows = $wpdb->get_results('SELECT id, catid, params
          FROM `' . $wpdb->prefix . 'wpgrabber`
          WHERE catid > 0');
            if (count($rows)) {
                foreach ($rows as $row) {
                    if (trim($row->params) == '') continue;
                    $params = base64_decode($row->params);
                    if ($params !== false) {
                        $params = ($params !== '') ? @unserialize($params) : array();
                        if ($params !== false) {
                            $params['catid'] = array($row->catid);
                            $params = base64_encode(serialize($params));
                            $result = $wpdb->update($wpdb->prefix . 'wpgrabber',
                                array(
                                    'params' => $params,
                                ),
                                array('id' => $row->id)
                            );
                            if ($result !== false) {
                                continue;
                            }
                        }
                    }
                    //die('Сбой при установке плагина. Ошибка обновления параметров версий ниже 3.0.2.');
                }
            }
            $sql = 'ALTER TABLE `' . $wpdb->prefix . 'wpgrabber` DROP `catid`;';
            if (!$wpdb->query($sql)) {
                die('Сбой при установке плагина. Ошибка обновления структуры БД версий ниже 3.0.2. Ошибка SQL: ' . $wpdb->last_error);
            }
        }
    }
    if (version_compare($current_wpg_core_version, '3.0.3', '<')) {
        // обновляем базу переводов системы Яндекс.Перевод, если задан API-ключ:
        if (get_option('wpg_yandexApiKey') and !get_option('wpg_yandexTransLangs')) {
            require_once(WPGRABBER_PLUGIN_CORE_DIR . 'WPGPlugin.php');
            WPGPlugin::translateYandexUpdate();
        }
    }
    if (version_compare($current_wpg_core_version, WPGRABBER_CORE_VERSION, '<')) {
        if (!$wpdb->query('TRUNCATE TABLE `' . $wpdb->prefix . 'wpgrabber_errors`')) {
            die('Сбой при установке плагина. Сбой БД при очистке логов. Ошибка SQL: ' . $wpdb->last_error);
        }
    }
    if (version_compare($current_wpg_core_version, '3.0.4', '<')) {
        if (!$wpdb->query('ALTER TABLE `' . $wpdb->prefix . 'wpgrabber` MODIFY `type` CHAR(8) NOT NULL')) {
            die('Сбой при установке плагина. Тип лент модификация. Ошибка SQL: ' . $wpdb->last_error);
        }
    }
}
    update_option('wpg_version', WPGRABBER_VERSION);
    update_option('wpg_core_version', WPGRABBER_CORE_VERSION);
    update_option('wpg_delFirstPic', '0', 'no');
    update_option('wpg_saveFileUrlMethod', '1', 'no');

    update_option('wpg_curlRedirectOn', 1, 'no');
    update_option('wpg_curlCookiesOn', 1, 'no');
    update_option('wpg_curlGzipOn', 1, 'no');

    # 14.12.2018
    update_option('wpg_image_name_from_title_on', 1, 'no');
    update_option('wpg_image_alt_make_on', 0, 'no');
    update_option('wpg_image_alt_replace', 0, 'no');
    update_option('wpg_image_alt_from_attr_title', 1, 'no');

    update_option('wpg_image_title_make_on', 0, 'no');

    update_option('wpg_image_class_name_on', 0, 'no');
    update_option('wpg_image_class_name_custom', 'wpg_image', 'no');

    update_option('wpg_image_attr_delete', 'itemprop,srcset,data-original,data-src,data-srcset,data-lazy-type,sizes', 'no');
    # 25.12.2018
    update_option('wpg_curlProxyHostPort', '127.0.0.1:8080', 'no');
    update_option('wpg_curlProxyType', 0, 'no');
    update_option('wpg_curlProxyHostPort_List', "193.110.17.83:41792\r\n202.162.221.250:48199\r\n222.124.215.187:38913\r\n188.136.242.81:9090\r\n62.24.109.89:60045", 'yes');

    #29.10.2020
    update_option('wpg_googleTransLangs', '{"af-en":"\\u0430\\u0444\\u0440\\u0438\\u043a\\u0430\\u0430\\u043d\\u0441 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","af-ru":"\\u0430\\u0444\\u0440\\u0438\\u043a\\u0430\\u0430\\u043d\\u0441 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","am-en":"\\u0430\\u043c\\u0445\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","am-ru":"\\u0430\\u043c\\u0445\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ar-en":"\\u0430\\u0440\\u0430\\u0431\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ar-ru":"\\u0430\\u0440\\u0430\\u0431\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","az-en":"\\u0430\\u0437\\u0435\\u0440\\u0431\\u0430\\u0439\\u0434\\u0436\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","az-ru":"\\u0430\\u0437\\u0435\\u0440\\u0431\\u0430\\u0439\\u0434\\u0436\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","be-en":"\\u0431\\u0435\\u043b\\u043e\\u0440\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","be-ru":"\\u0431\\u0435\\u043b\\u043e\\u0440\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","bg-en":"\\u0431\\u043e\\u043b\\u0433\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","bg-ru":"\\u0431\\u043e\\u043b\\u0433\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","bn-en":"\\u0431\\u0435\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","bn-ru":"\\u0431\\u0435\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","bs-en":"\\u0431\\u043e\\u0441\\u043d\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","bs-ru":"\\u0431\\u043e\\u0441\\u043d\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ca-en":"\\u043a\\u0430\\u0442\\u0430\\u043b\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ca-ru":"\\u043a\\u0430\\u0442\\u0430\\u043b\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ceb-en":"\\u0441\\u0435\\u0431\\u0443\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ceb-ru":"\\u0441\\u0435\\u0431\\u0443\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","co-en":"\\u043a\\u043e\\u0440\\u0441\\u0438\\u043a\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","co-ru":"\\u043a\\u043e\\u0440\\u0441\\u0438\\u043a\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","cs-en":"\\u0447\\u0435\\u0448\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","cs-ru":"\\u0447\\u0435\\u0448\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","cy-en":"\\u0432\\u0430\\u043b\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","cy-ru":"\\u0432\\u0430\\u043b\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","da-en":"\\u0434\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","da-ru":"\\u0434\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","de-en":"\\u043d\\u0435\\u043c\\u0435\\u0446\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","de-ru":"\\u043d\\u0435\\u043c\\u0435\\u0446\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","el-en":"\\u0433\\u0440\\u0435\\u0447\\u0435\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","el-ru":"\\u0433\\u0440\\u0435\\u0447\\u0435\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","en-af":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0444\\u0440\\u0438\\u043a\\u0430\\u0430\\u043d\\u0441","en-am":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u043c\\u0445\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439","en-ar":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0440\\u0430\\u0431\\u0441\\u043a\\u0438\\u0439","en-az":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0437\\u0435\\u0440\\u0431\\u0430\\u0439\\u0434\\u0436\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-be":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0435\\u043b\\u043e\\u0440\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","en-bg":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u043e\\u043b\\u0433\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439","en-bn":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0435\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","en-bs":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u043e\\u0441\\u043d\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","en-ca":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0430\\u0442\\u0430\\u043b\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-ceb":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0435\\u0431\\u0443\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-co":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u043e\\u0440\\u0441\\u0438\\u043a\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-cs":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0447\\u0435\\u0448\\u0441\\u043a\\u0438\\u0439","en-cy":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0432\\u0430\\u043b\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","en-da":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0434\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439","en-de":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u0435\\u043c\\u0435\\u0446\\u043a\\u0438\\u0439","en-el":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0440\\u0435\\u0447\\u0435\\u0441\\u043a\\u0438\\u0439","en-eo":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u044d\\u0441\\u043f\\u0435\\u0440\\u0430\\u043d\\u0442\\u043e","en-es":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0441\\u043f\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-et":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u044d\\u0441\\u0442\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439","en-eu":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0430\\u0441\\u043a\\u0441\\u043a\\u0438\\u0439","en-fa":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u0435\\u0440\\u0441\\u0438\\u0434\\u0441\\u043a\\u0438\\u0439","en-fi":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","en-fr":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0440\\u0430\\u043d\\u0446\\u0443\\u0437\\u0441\\u043a\\u0438\\u0439","en-fy":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0440\\u0438\\u0437\\u0441\\u043a\\u0438\\u0439","en-ga":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439","en-gd":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0448\\u043e\\u0442\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 (\\u0433\\u044d\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439)","en-gl":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0430\\u043b\\u0438\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","en-gu":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0443\\u0434\\u0436\\u0430\\u0440\\u0430\\u0442\\u0438","en-ha":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u0430\\u0443\\u0441\\u0430","en-haw":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0430\\u0432\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439","en-he":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0432\\u0440\\u0438\\u0442","en-hi":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u0438\\u043d\\u0434\\u0438","en-hmn":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u043c\\u043e\\u043d\\u0433","en-hr":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u043e\\u0440\\u0432\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439","en-ht":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0440\\u0435\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 (\\u0413\\u0430\\u0438\\u0442\\u0438)","en-hu":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0432\\u0435\\u043d\\u0433\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439","en-hy":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0440\\u043c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439","en-id":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u043d\\u0434\\u043e\\u043d\\u0435\\u0437\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","en-ig":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0433\\u0431\\u043e","en-is":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0441\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439","en-it":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0442\\u0430\\u043b\\u044c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439","en-iw":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0432\\u0440\\u0438\\u0442","en-ja":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u044f\\u043f\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439","en-jw":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u044f\\u0432\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-ka":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0440\\u0443\\u0437\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","en-kk":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0430\\u0437\\u0430\\u0445\\u0441\\u043a\\u0438\\u0439","en-km":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0445\\u043c\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439","en-kn":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0430\\u043d\\u043d\\u0430\\u0434\\u0430","en-ko":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u043e\\u0440\\u0435\\u0439\\u0441\\u043a\\u0438\\u0439","en-ku":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0443\\u0440\\u043c\\u0430\\u043d\\u0434\\u0436\\u0438","en-lb":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u044e\\u043a\\u0441\\u0435\\u043c\\u0431\\u0443\\u0440\\u0433\\u0441\\u043a\\u0438\\u0439","en-lo":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u0430\\u043e\\u0441\\u0441\\u043a\\u0438\\u0439","en-lt":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u0438\\u0442\\u043e\\u0432\\u0441\\u043a\\u0438\\u0439","en-lv":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u0430\\u0442\\u044b\\u0448\\u0441\\u043a\\u0438\\u0439","en-mg":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u0430\\u0433\\u0430\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","en-mi":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043e\\u0440\\u0438","en-mk":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043a\\u0435\\u0434\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439","en-ml":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u0430\\u044f\\u043b\\u0430\\u043c","en-mn":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u043e\\u043d\\u0433\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","en-mr":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u0440\\u0430\\u0442\\u0445\\u0438","en-ms":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439","en-mt":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u044c\\u0442\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","en-my":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0438\\u0440\\u043c\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-ne":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u0435\\u043f\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","en-nl":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u0438\\u0434\\u0435\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439","en-no":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u043e\\u0440\\u0432\\u0435\\u0436\\u0441\\u043a\\u0438\\u0439","en-ny":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0447\\u0435\\u0432\\u0430","en-pa":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u0430\\u043d\\u0434\\u0436\\u0430\\u0431\\u0438","en-pl":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","en-ps":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u0443\\u0448\\u0442\\u0443","en-pt":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u043e\\u0440\\u0442\\u0443\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","en-ro":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0440\\u0443\\u043c\\u044b\\u043d\\u0441\\u043a\\u0438\\u0439","en-ru":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0440\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","en-sd":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0438\\u043d\\u0434\\u0445\\u0438","en-si":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0438\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","en-sk":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u043b\\u043e\\u0432\\u0430\\u0446\\u043a\\u0438\\u0439","en-sl":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u043b\\u043e\\u0432\\u0435\\u043d\\u0441\\u043a\\u0438\\u0439","en-sm":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0430\\u043c\\u043e\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-sn":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0448\\u043e\\u043d\\u0430","en-so":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u043e\\u043c\\u0430\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","en-sq":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u043b\\u0431\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-sr":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0435\\u0440\\u0431\\u0441\\u043a\\u0438\\u0439","en-st":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0435\\u0441\\u043e\\u0442\\u043e","en-su":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0443\\u0434\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","en-sv":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0448\\u0432\\u0435\\u0434\\u0441\\u043a\\u0438\\u0439","en-sw":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0443\\u0430\\u0445\\u0438\\u043b\\u0438","en-ta":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0430\\u043c\\u0438\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","en-te":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0435\\u043b\\u0443\\u0433\\u0443","en-tg":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0430\\u0434\\u0436\\u0438\\u043a\\u0441\\u043a\\u0438\\u0439","en-th":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439","en-tl":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0438\\u043b\\u0438\\u043f\\u043f\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","en-tr":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0443\\u0440\\u0435\\u0446\\u043a\\u0438\\u0439","en-uk":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0443\\u043a\\u0440\\u0430\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","en-ur":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0443\\u0440\\u0434\\u0443","en-uz":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0443\\u0437\\u0431\\u0435\\u043a\\u0441\\u043a\\u0438\\u0439","en-vi":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0432\\u044c\\u0435\\u0442\\u043d\\u0430\\u043c\\u0441\\u043a\\u0438\\u0439","en-xh":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0445\\u043e\\u0441\\u0430","en-yi":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0434\\u0438\\u0448","en-yo":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0439\\u043e\\u0440\\u0443\\u0431\\u0430","en-zh":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439)","en-zh-CN":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439)","en-zh-TW":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0442\\u0440\\u0430\\u0434\\u0438\\u0446\\u0438\\u043e\\u043d\\u043d\\u044b\\u0439)","en-zu":"\\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0437\\u0443\\u043b\\u0443","eo-en":"\\u044d\\u0441\\u043f\\u0435\\u0440\\u0430\\u043d\\u0442\\u043e > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","eo-ru":"\\u044d\\u0441\\u043f\\u0435\\u0440\\u0430\\u043d\\u0442\\u043e > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","es-en":"\\u0438\\u0441\\u043f\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","es-ru":"\\u0438\\u0441\\u043f\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","et-en":"\\u044d\\u0441\\u0442\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","et-ru":"\\u044d\\u0441\\u0442\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","eu-en":"\\u0431\\u0430\\u0441\\u043a\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","eu-ru":"\\u0431\\u0430\\u0441\\u043a\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","fa-en":"\\u043f\\u0435\\u0440\\u0441\\u0438\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","fa-ru":"\\u043f\\u0435\\u0440\\u0441\\u0438\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","fi-en":"\\u0444\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","fi-ru":"\\u0444\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","fr-en":"\\u0444\\u0440\\u0430\\u043d\\u0446\\u0443\\u0437\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","fr-ru":"\\u0444\\u0440\\u0430\\u043d\\u0446\\u0443\\u0437\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","fy-en":"\\u0444\\u0440\\u0438\\u0437\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","fy-ru":"\\u0444\\u0440\\u0438\\u0437\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ga-en":"\\u0438\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ga-ru":"\\u0438\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","gd-en":"\\u0448\\u043e\\u0442\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 (\\u0433\\u044d\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439) > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","gd-ru":"\\u0448\\u043e\\u0442\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 (\\u0433\\u044d\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439) > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","gl-en":"\\u0433\\u0430\\u043b\\u0438\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","gl-ru":"\\u0433\\u0430\\u043b\\u0438\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","gu-en":"\\u0433\\u0443\\u0434\\u0436\\u0430\\u0440\\u0430\\u0442\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","gu-ru":"\\u0433\\u0443\\u0434\\u0436\\u0430\\u0440\\u0430\\u0442\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ha-en":"\\u0445\\u0430\\u0443\\u0441\\u0430 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ha-ru":"\\u0445\\u0430\\u0443\\u0441\\u0430 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","haw-en":"\\u0433\\u0430\\u0432\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","haw-ru":"\\u0433\\u0430\\u0432\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","he-en":"\\u0438\\u0432\\u0440\\u0438\\u0442 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","he-ru":"\\u0438\\u0432\\u0440\\u0438\\u0442 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","hi-en":"\\u0445\\u0438\\u043d\\u0434\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","hi-ru":"\\u0445\\u0438\\u043d\\u0434\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","hmn-en":"\\u0445\\u043c\\u043e\\u043d\\u0433 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","hmn-ru":"\\u0445\\u043c\\u043e\\u043d\\u0433 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","hr-en":"\\u0445\\u043e\\u0440\\u0432\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","hr-ru":"\\u0445\\u043e\\u0440\\u0432\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ht-en":"\\u043a\\u0440\\u0435\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 (\\u0413\\u0430\\u0438\\u0442\\u0438) > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ht-ru":"\\u043a\\u0440\\u0435\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 (\\u0413\\u0430\\u0438\\u0442\\u0438) > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","hu-en":"\\u0432\\u0435\\u043d\\u0433\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","hu-ru":"\\u0432\\u0435\\u043d\\u0433\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","hy-en":"\\u0430\\u0440\\u043c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","hy-ru":"\\u0430\\u0440\\u043c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","id-en":"\\u0438\\u043d\\u0434\\u043e\\u043d\\u0435\\u0437\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","id-ru":"\\u0438\\u043d\\u0434\\u043e\\u043d\\u0435\\u0437\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ig-en":"\\u0438\\u0433\\u0431\\u043e > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ig-ru":"\\u0438\\u0433\\u0431\\u043e > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","is-en":"\\u0438\\u0441\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","is-ru":"\\u0438\\u0441\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","it-en":"\\u0438\\u0442\\u0430\\u043b\\u044c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","it-ru":"\\u0438\\u0442\\u0430\\u043b\\u044c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","iw-en":"\\u0438\\u0432\\u0440\\u0438\\u0442 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","iw-ru":"\\u0438\\u0432\\u0440\\u0438\\u0442 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ja-en":"\\u044f\\u043f\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ja-ru":"\\u044f\\u043f\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","jw-en":"\\u044f\\u0432\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","jw-ru":"\\u044f\\u0432\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ka-en":"\\u0433\\u0440\\u0443\\u0437\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ka-ru":"\\u0433\\u0440\\u0443\\u0437\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","kk-en":"\\u043a\\u0430\\u0437\\u0430\\u0445\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","kk-ru":"\\u043a\\u0430\\u0437\\u0430\\u0445\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","km-en":"\\u043a\\u0445\\u043c\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","km-ru":"\\u043a\\u0445\\u043c\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","kn-en":"\\u043a\\u0430\\u043d\\u043d\\u0430\\u0434\\u0430 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","kn-ru":"\\u043a\\u0430\\u043d\\u043d\\u0430\\u0434\\u0430 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ko-en":"\\u043a\\u043e\\u0440\\u0435\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ko-ru":"\\u043a\\u043e\\u0440\\u0435\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ku-en":"\\u043a\\u0443\\u0440\\u043c\\u0430\\u043d\\u0434\\u0436\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ku-ru":"\\u043a\\u0443\\u0440\\u043c\\u0430\\u043d\\u0434\\u0436\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","lb-en":"\\u043b\\u044e\\u043a\\u0441\\u0435\\u043c\\u0431\\u0443\\u0440\\u0433\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","lb-ru":"\\u043b\\u044e\\u043a\\u0441\\u0435\\u043c\\u0431\\u0443\\u0440\\u0433\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","lo-en":"\\u043b\\u0430\\u043e\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","lo-ru":"\\u043b\\u0430\\u043e\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","lt-en":"\\u043b\\u0438\\u0442\\u043e\\u0432\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","lt-ru":"\\u043b\\u0438\\u0442\\u043e\\u0432\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","lv-en":"\\u043b\\u0430\\u0442\\u044b\\u0448\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","lv-ru":"\\u043b\\u0430\\u0442\\u044b\\u0448\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","mg-en":"\\u043c\\u0430\\u043b\\u0430\\u0433\\u0430\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","mg-ru":"\\u043c\\u0430\\u043b\\u0430\\u0433\\u0430\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","mi-en":"\\u043c\\u0430\\u043e\\u0440\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","mi-ru":"\\u043c\\u0430\\u043e\\u0440\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","mk-en":"\\u043c\\u0430\\u043a\\u0435\\u0434\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","mk-ru":"\\u043c\\u0430\\u043a\\u0435\\u0434\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ml-en":"\\u043c\\u0430\\u043b\\u0430\\u044f\\u043b\\u0430\\u043c > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ml-ru":"\\u043c\\u0430\\u043b\\u0430\\u044f\\u043b\\u0430\\u043c > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","mn-en":"\\u043c\\u043e\\u043d\\u0433\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","mn-ru":"\\u043c\\u043e\\u043d\\u0433\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","mr-en":"\\u043c\\u0430\\u0440\\u0430\\u0442\\u0445\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","mr-ru":"\\u043c\\u0430\\u0440\\u0430\\u0442\\u0445\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ms-en":"\\u043c\\u0430\\u043b\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ms-ru":"\\u043c\\u0430\\u043b\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","mt-en":"\\u043c\\u0430\\u043b\\u044c\\u0442\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","mt-ru":"\\u043c\\u0430\\u043b\\u044c\\u0442\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","my-en":"\\u0431\\u0438\\u0440\\u043c\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","my-ru":"\\u0431\\u0438\\u0440\\u043c\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ne-en":"\\u043d\\u0435\\u043f\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ne-ru":"\\u043d\\u0435\\u043f\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","nl-en":"\\u043d\\u0438\\u0434\\u0435\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","nl-ru":"\\u043d\\u0438\\u0434\\u0435\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","no-en":"\\u043d\\u043e\\u0440\\u0432\\u0435\\u0436\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","no-ru":"\\u043d\\u043e\\u0440\\u0432\\u0435\\u0436\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ny-en":"\\u0447\\u0435\\u0432\\u0430 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ny-ru":"\\u0447\\u0435\\u0432\\u0430 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","pa-en":"\\u043f\\u0430\\u043d\\u0434\\u0436\\u0430\\u0431\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","pa-ru":"\\u043f\\u0430\\u043d\\u0434\\u0436\\u0430\\u0431\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","pl-en":"\\u043f\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","pl-ru":"\\u043f\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ps-en":"\\u043f\\u0443\\u0448\\u0442\\u0443 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ps-ru":"\\u043f\\u0443\\u0448\\u0442\\u0443 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","pt-en":"\\u043f\\u043e\\u0440\\u0442\\u0443\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","pt-ru":"\\u043f\\u043e\\u0440\\u0442\\u0443\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ro-en":"\\u0440\\u0443\\u043c\\u044b\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ro-ru":"\\u0440\\u0443\\u043c\\u044b\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ru-af":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0444\\u0440\\u0438\\u043a\\u0430\\u0430\\u043d\\u0441","ru-am":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u043c\\u0445\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439","ru-ar":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0440\\u0430\\u0431\\u0441\\u043a\\u0438\\u0439","ru-az":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0437\\u0435\\u0440\\u0431\\u0430\\u0439\\u0434\\u0436\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-be":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0435\\u043b\\u043e\\u0440\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ru-bg":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u043e\\u043b\\u0433\\u0430\\u0440\\u0441\\u043a\\u0438\\u0439","ru-bn":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0435\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","ru-bs":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u043e\\u0441\\u043d\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-ca":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0430\\u0442\\u0430\\u043b\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-ceb":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0435\\u0431\\u0443\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-co":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u043e\\u0440\\u0441\\u0438\\u043a\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-cs":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0447\\u0435\\u0448\\u0441\\u043a\\u0438\\u0439","ru-cy":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0432\\u0430\\u043b\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-da":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0434\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439","ru-de":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u0435\\u043c\\u0435\\u0446\\u043a\\u0438\\u0439","ru-el":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0440\\u0435\\u0447\\u0435\\u0441\\u043a\\u0438\\u0439","ru-en":"\\u0440\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-eo":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u044d\\u0441\\u043f\\u0435\\u0440\\u0430\\u043d\\u0442\\u043e","ru-es":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0441\\u043f\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-et":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u044d\\u0441\\u0442\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439","ru-eu":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0430\\u0441\\u043a\\u0441\\u043a\\u0438\\u0439","ru-fa":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u0435\\u0440\\u0441\\u0438\\u0434\\u0441\\u043a\\u0438\\u0439","ru-fi":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","ru-fr":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0440\\u0430\\u043d\\u0446\\u0443\\u0437\\u0441\\u043a\\u0438\\u0439","ru-fy":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0440\\u0438\\u0437\\u0441\\u043a\\u0438\\u0439","ru-ga":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439","ru-gd":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0448\\u043e\\u0442\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439 (\\u0433\\u044d\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439)","ru-gl":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0430\\u043b\\u0438\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-gu":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0443\\u0434\\u0436\\u0430\\u0440\\u0430\\u0442\\u0438","ru-ha":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u0430\\u0443\\u0441\\u0430","ru-haw":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0430\\u0432\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439","ru-he":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0432\\u0440\\u0438\\u0442","ru-hi":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u0438\\u043d\\u0434\\u0438","ru-hmn":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u043c\\u043e\\u043d\\u0433","ru-hr":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0445\\u043e\\u0440\\u0432\\u0430\\u0442\\u0441\\u043a\\u0438\\u0439","ru-ht":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0440\\u0435\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 (\\u0413\\u0430\\u0438\\u0442\\u0438)","ru-hu":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0432\\u0435\\u043d\\u0433\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439","ru-hy":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u0440\\u043c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439","ru-id":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u043d\\u0434\\u043e\\u043d\\u0435\\u0437\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-ig":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0433\\u0431\\u043e","ru-is":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0441\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439","ru-it":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0442\\u0430\\u043b\\u044c\\u044f\\u043d\\u0441\\u043a\\u0438\\u0439","ru-iw":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0432\\u0440\\u0438\\u0442","ru-ja":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u044f\\u043f\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439","ru-jw":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u044f\\u0432\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-ka":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0433\\u0440\\u0443\\u0437\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","ru-kk":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0430\\u0437\\u0430\\u0445\\u0441\\u043a\\u0438\\u0439","ru-km":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0445\\u043c\\u0435\\u0440\\u0441\\u043a\\u0438\\u0439","ru-kn":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0430\\u043d\\u043d\\u0430\\u0434\\u0430","ru-ko":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u043e\\u0440\\u0435\\u0439\\u0441\\u043a\\u0438\\u0439","ru-ku":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0443\\u0440\\u043c\\u0430\\u043d\\u0434\\u0436\\u0438","ru-lb":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u044e\\u043a\\u0441\\u0435\\u043c\\u0431\\u0443\\u0440\\u0433\\u0441\\u043a\\u0438\\u0439","ru-lo":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u0430\\u043e\\u0441\\u0441\\u043a\\u0438\\u0439","ru-lt":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u0438\\u0442\\u043e\\u0432\\u0441\\u043a\\u0438\\u0439","ru-lv":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043b\\u0430\\u0442\\u044b\\u0448\\u0441\\u043a\\u0438\\u0439","ru-mg":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u0430\\u0433\\u0430\\u0441\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-mi":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043e\\u0440\\u0438","ru-mk":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043a\\u0435\\u0434\\u043e\\u043d\\u0441\\u043a\\u0438\\u0439","ru-ml":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u0430\\u044f\\u043b\\u0430\\u043c","ru-mn":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u043e\\u043d\\u0433\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","ru-mr":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u0440\\u0430\\u0442\\u0445\\u0438","ru-ms":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439","ru-mt":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043c\\u0430\\u043b\\u044c\\u0442\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-my":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0431\\u0438\\u0440\\u043c\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-ne":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u0435\\u043f\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","ru-nl":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u0438\\u0434\\u0435\\u0440\\u043b\\u0430\\u043d\\u0434\\u0441\\u043a\\u0438\\u0439","ru-no":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043d\\u043e\\u0440\\u0432\\u0435\\u0436\\u0441\\u043a\\u0438\\u0439","ru-ny":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0447\\u0435\\u0432\\u0430","ru-pa":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u0430\\u043d\\u0434\\u0436\\u0430\\u0431\\u0438","ru-pl":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u043e\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","ru-ps":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u0443\\u0448\\u0442\\u0443","ru-pt":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043f\\u043e\\u0440\\u0442\\u0443\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","ru-ro":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0440\\u0443\\u043c\\u044b\\u043d\\u0441\\u043a\\u0438\\u0439","ru-sd":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0438\\u043d\\u0434\\u0445\\u0438","ru-si":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0438\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","ru-sk":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u043b\\u043e\\u0432\\u0430\\u0446\\u043a\\u0438\\u0439","ru-sl":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u043b\\u043e\\u0432\\u0435\\u043d\\u0441\\u043a\\u0438\\u0439","ru-sm":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0430\\u043c\\u043e\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-sn":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0448\\u043e\\u043d\\u0430","ru-so":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u043e\\u043c\\u0430\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ru-sq":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0430\\u043b\\u0431\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-sr":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0435\\u0440\\u0431\\u0441\\u043a\\u0438\\u0439","ru-st":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0435\\u0441\\u043e\\u0442\\u043e","ru-su":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0443\\u0434\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439","ru-sv":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0448\\u0432\\u0435\\u0434\\u0441\\u043a\\u0438\\u0439","ru-sw":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0441\\u0443\\u0430\\u0445\\u0438\\u043b\\u0438","ru-ta":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0430\\u043c\\u0438\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439","ru-te":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0435\\u043b\\u0443\\u0433\\u0443","ru-tg":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0430\\u0434\\u0436\\u0438\\u043a\\u0441\\u043a\\u0438\\u0439","ru-th":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439","ru-tl":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0444\\u0438\\u043b\\u0438\\u043f\\u043f\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","ru-tr":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0442\\u0443\\u0440\\u0435\\u0446\\u043a\\u0438\\u0439","ru-uk":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0443\\u043a\\u0440\\u0430\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439","ru-ur":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0443\\u0440\\u0434\\u0443","ru-uz":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0443\\u0437\\u0431\\u0435\\u043a\\u0441\\u043a\\u0438\\u0439","ru-vi":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0432\\u044c\\u0435\\u0442\\u043d\\u0430\\u043c\\u0441\\u043a\\u0438\\u0439","ru-xh":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0445\\u043e\\u0441\\u0430","ru-yi":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0438\\u0434\\u0438\\u0448","ru-yo":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0439\\u043e\\u0440\\u0443\\u0431\\u0430","ru-zh":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439)","ru-zh-CN":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439)","ru-zh-TW":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0442\\u0440\\u0430\\u0434\\u0438\\u0446\\u0438\\u043e\\u043d\\u043d\\u044b\\u0439)","ru-zu":"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 > \\u0437\\u0443\\u043b\\u0443","sd-en":"\\u0441\\u0438\\u043d\\u0434\\u0445\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sd-ru":"\\u0441\\u0438\\u043d\\u0434\\u0445\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","si-en":"\\u0441\\u0438\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","si-ru":"\\u0441\\u0438\\u043d\\u0433\\u0430\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sk-en":"\\u0441\\u043b\\u043e\\u0432\\u0430\\u0446\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sk-ru":"\\u0441\\u043b\\u043e\\u0432\\u0430\\u0446\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sl-en":"\\u0441\\u043b\\u043e\\u0432\\u0435\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sl-ru":"\\u0441\\u043b\\u043e\\u0432\\u0435\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sm-en":"\\u0441\\u0430\\u043c\\u043e\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sm-ru":"\\u0441\\u0430\\u043c\\u043e\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sn-en":"\\u0448\\u043e\\u043d\\u0430 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sn-ru":"\\u0448\\u043e\\u043d\\u0430 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","so-en":"\\u0441\\u043e\\u043c\\u0430\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","so-ru":"\\u0441\\u043e\\u043c\\u0430\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sq-en":"\\u0430\\u043b\\u0431\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sq-ru":"\\u0430\\u043b\\u0431\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sr-en":"\\u0441\\u0435\\u0440\\u0431\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sr-ru":"\\u0441\\u0435\\u0440\\u0431\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","st-en":"\\u0441\\u0435\\u0441\\u043e\\u0442\\u043e > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","st-ru":"\\u0441\\u0435\\u0441\\u043e\\u0442\\u043e > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","su-en":"\\u0441\\u0443\\u0434\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","su-ru":"\\u0441\\u0443\\u0434\\u0430\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sv-en":"\\u0448\\u0432\\u0435\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sv-ru":"\\u0448\\u0432\\u0435\\u0434\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","sw-en":"\\u0441\\u0443\\u0430\\u0445\\u0438\\u043b\\u0438 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","sw-ru":"\\u0441\\u0443\\u0430\\u0445\\u0438\\u043b\\u0438 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ta-en":"\\u0442\\u0430\\u043c\\u0438\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ta-ru":"\\u0442\\u0430\\u043c\\u0438\\u043b\\u044c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","te-en":"\\u0442\\u0435\\u043b\\u0443\\u0433\\u0443 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","te-ru":"\\u0442\\u0435\\u043b\\u0443\\u0433\\u0443 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","tg-en":"\\u0442\\u0430\\u0434\\u0436\\u0438\\u043a\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","tg-ru":"\\u0442\\u0430\\u0434\\u0436\\u0438\\u043a\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","th-en":"\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","th-ru":"\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","tl-en":"\\u0444\\u0438\\u043b\\u0438\\u043f\\u043f\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","tl-ru":"\\u0444\\u0438\\u043b\\u0438\\u043f\\u043f\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","tr-en":"\\u0442\\u0443\\u0440\\u0435\\u0446\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","tr-ru":"\\u0442\\u0443\\u0440\\u0435\\u0446\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","uk-en":"\\u0443\\u043a\\u0440\\u0430\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","uk-ru":"\\u0443\\u043a\\u0440\\u0430\\u0438\\u043d\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","ur-en":"\\u0443\\u0440\\u0434\\u0443 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","ur-ru":"\\u0443\\u0440\\u0434\\u0443 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","uz-en":"\\u0443\\u0437\\u0431\\u0435\\u043a\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","uz-ru":"\\u0443\\u0437\\u0431\\u0435\\u043a\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","vi-en":"\\u0432\\u044c\\u0435\\u0442\\u043d\\u0430\\u043c\\u0441\\u043a\\u0438\\u0439 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","vi-ru":"\\u0432\\u044c\\u0435\\u0442\\u043d\\u0430\\u043c\\u0441\\u043a\\u0438\\u0439 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","xh-en":"\\u043a\\u0445\\u043e\\u0441\\u0430 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","xh-ru":"\\u043a\\u0445\\u043e\\u0441\\u0430 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","yi-en":"\\u0438\\u0434\\u0438\\u0448 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","yi-ru":"\\u0438\\u0434\\u0438\\u0448 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","yo-en":"\\u0439\\u043e\\u0440\\u0443\\u0431\\u0430 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","yo-ru":"\\u0439\\u043e\\u0440\\u0443\\u0431\\u0430 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","zh-CN-en":"\\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439) > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","zh-CN-ru":"\\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439) > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","zh-TW-en":"\\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0442\\u0440\\u0430\\u0434\\u0438\\u0446\\u0438\\u043e\\u043d\\u043d\\u044b\\u0439) > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","zh-TW-ru":"\\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0442\\u0440\\u0430\\u0434\\u0438\\u0446\\u0438\\u043e\\u043d\\u043d\\u044b\\u0439) > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","zh-en":"\\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439) > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","zh-ru":"\\u043a\\u0438\\u0442\\u0430\\u0439\\u0441\\u043a\\u0438\\u0439 (\\u0443\\u043f\\u0440\\u043e\\u0449\\u0435\\u043d\\u043d\\u044b\\u0439) > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","zu-en":"\\u0437\\u0443\\u043b\\u0443 > \\u0410\\u043d\\u0433\\u043b\\u0438\\u0439\\u0441\\u043a\\u0438\\u0439","zu-ru":"\\u0437\\u0443\\u043b\\u0443 > \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439"}' , 'no');

    #15.12.2020
    update_option('wpg_userAgent', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.89 Safari/537.36', 'no');
    update_option('wpg_yandexCloudTransLangs', '{"af-en":"Afrikaans > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","af-ru":"Afrikaans > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","am-en":"\u12a0\u121b\u122d\u129b > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","am-ru":"\u12a0\u121b\u122d\u129b > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ar-en":"\u0627\u0644\u0639\u0631\u0628\u064a\u0629 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ar-ru":"\u0627\u0644\u0639\u0631\u0628\u064a\u0629 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","az-en":"az\u0259rbaycan > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","az-ru":"az\u0259rbaycan > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ba-en":"ba > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ba-ru":"ba > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","be-en":"\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","be-ru":"\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","bg-en":"\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","bg-ru":"\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","bn-en":"\u09ac\u09be\u0982\u09b2\u09be > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","bn-ru":"\u09ac\u09be\u0982\u09b2\u09be > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","bs-en":"bosanski > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","bs-ru":"bosanski > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ca-en":"catal\u00e0 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ca-ru":"catal\u00e0 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","cs-en":"\u010de\u0161tina > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","cs-ru":"\u010de\u0161tina > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","cy-en":"Cymraeg > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","cy-ru":"Cymraeg > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","da-en":"dansk > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","da-ru":"dansk > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","de-en":"Deutsch > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","de-ru":"Deutsch > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","el-en":"\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","el-ru":"\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","en-af":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Afrikaans","en-am":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u12a0\u121b\u122d\u129b","en-ar":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0627\u0644\u0639\u0631\u0628\u064a\u0629","en-az":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > az\u0259rbaycan","en-ba":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > ba","en-be":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f","en-bg":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438","en-bn":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u09ac\u09be\u0982\u09b2\u09be","en-bs":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > bosanski","en-ca":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > catal\u00e0","en-cs":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u010de\u0161tina","en-cy":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Cymraeg","en-da":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > dansk","en-de":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Deutsch","en-el":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac","en-eo":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > esperanto","en-es":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > espa\u00f1ol","en-et":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > eesti","en-eu":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > euskara","en-fa":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0641\u0627\u0631\u0633\u06cc","en-fi":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > suomi","en-fr":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > fran\u00e7ais","en-ga":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Gaeilge","en-gd":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > G\u00e0idhlig","en-gl":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > galego","en-gu":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0","en-he":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u05e2\u05d1\u05e8\u05d9\u05ea","en-hi":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0939\u093f\u0928\u094d\u0926\u0940","en-hr":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > hrvatski","en-ht":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > ht","en-hu":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > magyar","en-hy":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0570\u0561\u0575\u0565\u0580\u0565\u0576","en-id":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Indonesia","en-is":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u00edslenska","en-it":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > italiano","en-ja":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u65e5\u672c\u8a9e","en-jv":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > jv","en-ka":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8","en-kk":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u049b\u0430\u0437\u0430\u049b \u0442\u0456\u043b\u0456","en-km":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u1781\u17d2\u1798\u17c2\u179a","en-kn":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0c95\u0ca8\u0ccd\u0ca8\u0ca1","en-ko":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \ud55c\uad6d\uc5b4","en-ky":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u043a\u044b\u0440\u0433\u044b\u0437\u0447\u0430","en-la":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > la","en-lb":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > L\u00ebtzebuergesch","en-lo":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0ea5\u0eb2\u0ea7","en-lt":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > lietuvi\u0173","en-lv":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > latvie\u0161u","en-mg":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Malagasy","en-mi":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > mi","en-mk":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438","en-ml":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02","en-mn":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u043c\u043e\u043d\u0433\u043e\u043b","en-mr":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u092e\u0930\u093e\u0920\u0940","en-ms":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Melayu","en-mt":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Malti","en-my":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u1019\u103c\u1014\u103a\u1019\u102c","en-ne":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0928\u0947\u092a\u093e\u0932\u0940","en-nl":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Nederlands","en-no":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > norsk bokm\u00e5l","en-pa":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40","en-pl":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > polski","en-pt":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > portugu\u00eas","en-ro":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > rom\u00e2n\u0103","en-ru":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0440\u0443\u0441\u0441\u043a\u0438\u0439","en-si":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0dc3\u0dd2\u0d82\u0dc4\u0dbd","en-sk":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > sloven\u010dina","en-sl":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > sloven\u0161\u010dina","en-sq":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > shqip","en-sr":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0441\u0440\u043f\u0441\u043a\u0438","en-su":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > su","en-sv":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > svenska","en-sw":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Kiswahili","en-ta":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0ba4\u0bae\u0bbf\u0bb4\u0bcd","en-te":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0c24\u0c46\u0c32\u0c41\u0c17\u0c41","en-tg":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0442\u043e\u04b7\u0438\u043a\u04e3","en-th":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0e44\u0e17\u0e22","en-tl":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Filipino","en-tr":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > T\u00fcrk\u00e7e","en-tt":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0442\u0430\u0442\u0430\u0440","en-uk":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430","en-ur":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u0627\u0631\u062f\u0648","en-uz":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > o\u2018zbek","en-vi":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > Ti\u1ebfng Vi\u1ec7t","en-xh":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > xh","en-yi":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u05d9\u05d9\u05b4\u05d3\u05d9\u05e9","en-zh":"\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 > \u4e2d\u6587","eo-en":"esperanto > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","eo-ru":"esperanto > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","es-en":"espa\u00f1ol > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","es-ru":"espa\u00f1ol > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","et-en":"eesti > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","et-ru":"eesti > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","eu-en":"euskara > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","eu-ru":"euskara > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","fa-en":"\u0641\u0627\u0631\u0633\u06cc > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","fa-ru":"\u0641\u0627\u0631\u0633\u06cc > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","fi-en":"suomi > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","fi-ru":"suomi > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","fr-en":"fran\u00e7ais > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","fr-ru":"fran\u00e7ais > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ga-en":"Gaeilge > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ga-ru":"Gaeilge > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","gd-en":"G\u00e0idhlig > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","gd-ru":"G\u00e0idhlig > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","gl-en":"galego > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","gl-ru":"galego > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","gu-en":"\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","gu-ru":"\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","he-en":"\u05e2\u05d1\u05e8\u05d9\u05ea > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","he-ru":"\u05e2\u05d1\u05e8\u05d9\u05ea > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","hi-en":"\u0939\u093f\u0928\u094d\u0926\u0940 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","hi-ru":"\u0939\u093f\u0928\u094d\u0926\u0940 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","hr-en":"hrvatski > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","hr-ru":"hrvatski > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ht-en":"ht > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ht-ru":"ht > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","hu-en":"magyar > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","hu-ru":"magyar > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","hy-en":"\u0570\u0561\u0575\u0565\u0580\u0565\u0576 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","hy-ru":"\u0570\u0561\u0575\u0565\u0580\u0565\u0576 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","id-en":"Indonesia > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","id-ru":"Indonesia > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","is-en":"\u00edslenska > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","is-ru":"\u00edslenska > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","it-en":"italiano > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","it-ru":"italiano > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ja-en":"\u65e5\u672c\u8a9e > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ja-ru":"\u65e5\u672c\u8a9e > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","jv-en":"jv > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","jv-ru":"jv > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ka-en":"\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ka-ru":"\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","kk-en":"\u049b\u0430\u0437\u0430\u049b \u0442\u0456\u043b\u0456 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","kk-ru":"\u049b\u0430\u0437\u0430\u049b \u0442\u0456\u043b\u0456 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","km-en":"\u1781\u17d2\u1798\u17c2\u179a > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","km-ru":"\u1781\u17d2\u1798\u17c2\u179a > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","kn-en":"\u0c95\u0ca8\u0ccd\u0ca8\u0ca1 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","kn-ru":"\u0c95\u0ca8\u0ccd\u0ca8\u0ca1 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ko-en":"\ud55c\uad6d\uc5b4 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ko-ru":"\ud55c\uad6d\uc5b4 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ky-en":"\u043a\u044b\u0440\u0433\u044b\u0437\u0447\u0430 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ky-ru":"\u043a\u044b\u0440\u0433\u044b\u0437\u0447\u0430 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","la-en":"la > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","la-ru":"la > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","lb-en":"L\u00ebtzebuergesch > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","lb-ru":"L\u00ebtzebuergesch > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","lo-en":"\u0ea5\u0eb2\u0ea7 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","lo-ru":"\u0ea5\u0eb2\u0ea7 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","lt-en":"lietuvi\u0173 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","lt-ru":"lietuvi\u0173 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","lv-en":"latvie\u0161u > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","lv-ru":"latvie\u0161u > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","mg-en":"Malagasy > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","mg-ru":"Malagasy > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","mi-en":"mi > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","mi-ru":"mi > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","mk-en":"\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","mk-ru":"\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ml-en":"\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ml-ru":"\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","mn-en":"\u043c\u043e\u043d\u0433\u043e\u043b > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","mn-ru":"\u043c\u043e\u043d\u0433\u043e\u043b > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","mr-en":"\u092e\u0930\u093e\u0920\u0940 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","mr-ru":"\u092e\u0930\u093e\u0920\u0940 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ms-en":"Melayu > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ms-ru":"Melayu > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","mt-en":"Malti > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","mt-ru":"Malti > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","my-en":"\u1019\u103c\u1014\u103a\u1019\u102c > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","my-ru":"\u1019\u103c\u1014\u103a\u1019\u102c > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ne-en":"\u0928\u0947\u092a\u093e\u0932\u0940 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ne-ru":"\u0928\u0947\u092a\u093e\u0932\u0940 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","nl-en":"Nederlands > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","nl-ru":"Nederlands > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","no-en":"norsk bokm\u00e5l > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","no-ru":"norsk bokm\u00e5l > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","pa-en":"\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","pa-ru":"\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","pl-en":"polski > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","pl-ru":"polski > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","pt-en":"portugu\u00eas > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","pt-ru":"portugu\u00eas > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ro-en":"rom\u00e2n\u0103 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ro-ru":"rom\u00e2n\u0103 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ru-af":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Afrikaans","ru-am":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u12a0\u121b\u122d\u129b","ru-ar":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0627\u0644\u0639\u0631\u0628\u064a\u0629","ru-az":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > az\u0259rbaycan","ru-ba":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > ba","ru-be":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f","ru-bg":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438","ru-bn":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u09ac\u09be\u0982\u09b2\u09be","ru-bs":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > bosanski","ru-ca":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > catal\u00e0","ru-cs":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u010de\u0161tina","ru-cy":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Cymraeg","ru-da":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > dansk","ru-de":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Deutsch","ru-el":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac","ru-en":"\u0440\u0443\u0441\u0441\u043a\u0438\u0439 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ru-eo":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > esperanto","ru-es":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > espa\u00f1ol","ru-et":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > eesti","ru-eu":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > euskara","ru-fa":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0641\u0627\u0631\u0633\u06cc","ru-fi":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > suomi","ru-fr":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > fran\u00e7ais","ru-ga":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Gaeilge","ru-gd":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > G\u00e0idhlig","ru-gl":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > galego","ru-gu":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0","ru-he":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u05e2\u05d1\u05e8\u05d9\u05ea","ru-hi":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0939\u093f\u0928\u094d\u0926\u0940","ru-hr":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > hrvatski","ru-ht":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > ht","ru-hu":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > magyar","ru-hy":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0570\u0561\u0575\u0565\u0580\u0565\u0576","ru-id":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Indonesia","ru-is":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u00edslenska","ru-it":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > italiano","ru-ja":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u65e5\u672c\u8a9e","ru-jv":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > jv","ru-ka":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8","ru-kk":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u049b\u0430\u0437\u0430\u049b \u0442\u0456\u043b\u0456","ru-km":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u1781\u17d2\u1798\u17c2\u179a","ru-kn":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0c95\u0ca8\u0ccd\u0ca8\u0ca1","ru-ko":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \ud55c\uad6d\uc5b4","ru-ky":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u043a\u044b\u0440\u0433\u044b\u0437\u0447\u0430","ru-la":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > la","ru-lb":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > L\u00ebtzebuergesch","ru-lo":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0ea5\u0eb2\u0ea7","ru-lt":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > lietuvi\u0173","ru-lv":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > latvie\u0161u","ru-mg":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Malagasy","ru-mi":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > mi","ru-mk":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438","ru-ml":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02","ru-mn":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u043c\u043e\u043d\u0433\u043e\u043b","ru-mr":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u092e\u0930\u093e\u0920\u0940","ru-ms":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Melayu","ru-mt":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Malti","ru-my":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u1019\u103c\u1014\u103a\u1019\u102c","ru-ne":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0928\u0947\u092a\u093e\u0932\u0940","ru-nl":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Nederlands","ru-no":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > norsk bokm\u00e5l","ru-pa":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40","ru-pl":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > polski","ru-pt":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > portugu\u00eas","ru-ro":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > rom\u00e2n\u0103","ru-si":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0dc3\u0dd2\u0d82\u0dc4\u0dbd","ru-sk":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > sloven\u010dina","ru-sl":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > sloven\u0161\u010dina","ru-sq":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > shqip","ru-sr":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0441\u0440\u043f\u0441\u043a\u0438","ru-su":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > su","ru-sv":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > svenska","ru-sw":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Kiswahili","ru-ta":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0ba4\u0bae\u0bbf\u0bb4\u0bcd","ru-te":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0c24\u0c46\u0c32\u0c41\u0c17\u0c41","ru-tg":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0442\u043e\u04b7\u0438\u043a\u04e3","ru-th":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0e44\u0e17\u0e22","ru-tl":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Filipino","ru-tr":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > T\u00fcrk\u00e7e","ru-tt":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0442\u0430\u0442\u0430\u0440","ru-uk":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430","ru-ur":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u0627\u0631\u062f\u0648","ru-uz":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > o\u2018zbek","ru-vi":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > Ti\u1ebfng Vi\u1ec7t","ru-xh":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > xh","ru-yi":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u05d9\u05d9\u05b4\u05d3\u05d9\u05e9","ru-zh":"\u0420\u0443\u0441\u0441\u043a\u0438\u0439 > \u4e2d\u6587","si-en":"\u0dc3\u0dd2\u0d82\u0dc4\u0dbd > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","si-ru":"\u0dc3\u0dd2\u0d82\u0dc4\u0dbd > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","sk-en":"sloven\u010dina > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","sk-ru":"sloven\u010dina > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","sl-en":"sloven\u0161\u010dina > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","sl-ru":"sloven\u0161\u010dina > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","sq-en":"shqip > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","sq-ru":"shqip > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","sr-en":"\u0441\u0440\u043f\u0441\u043a\u0438 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","sr-ru":"\u0441\u0440\u043f\u0441\u043a\u0438 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","su-en":"su > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","su-ru":"su > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","sv-en":"svenska > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","sv-ru":"svenska > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","sw-en":"Kiswahili > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","sw-ru":"Kiswahili > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ta-en":"\u0ba4\u0bae\u0bbf\u0bb4\u0bcd > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ta-ru":"\u0ba4\u0bae\u0bbf\u0bb4\u0bcd > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","te-en":"\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","te-ru":"\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","tg-en":"\u0442\u043e\u04b7\u0438\u043a\u04e3 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","tg-ru":"\u0442\u043e\u04b7\u0438\u043a\u04e3 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","th-en":"\u0e44\u0e17\u0e22 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","th-ru":"\u0e44\u0e17\u0e22 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","tl-en":"Filipino > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","tl-ru":"Filipino > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","tr-en":"T\u00fcrk\u00e7e > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","tr-ru":"T\u00fcrk\u00e7e > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","tt-en":"\u0442\u0430\u0442\u0430\u0440 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","tt-ru":"\u0442\u0430\u0442\u0430\u0440 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","uk-en":"\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","uk-ru":"\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","ur-en":"\u0627\u0631\u062f\u0648 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","ur-ru":"\u0627\u0631\u062f\u0648 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","uz-en":"o\u2018zbek > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","uz-ru":"o\u2018zbek > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","vi-en":"Ti\u1ebfng Vi\u1ec7t > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","vi-ru":"Ti\u1ebfng Vi\u1ec7t > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","xh-en":"xh > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","xh-ru":"xh > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","yi-en":"\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","yi-ru":"\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439","zh-en":"\u4e2d\u6587 > \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439","zh-ru":"\u4e2d\u6587 > \u0420\u0443\u0441\u0441\u043a\u0438\u0439"}', 'no');
    #12.02.2021
    update_option('wpg_vk_app_id', '', 'no');
    update_option('wpg_vk_access_token_url', '', 'yes');
    update_option('wpg_vk_access_token', '', 'yes');